/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.cio;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.DecoratingInputSocket;
import net.java.truecommons.cio.DecoratingOutputService;
import net.java.truecommons.cio.DecoratingOutputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.IoSockets;
import net.java.truecommons.cio.MutableEntry;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.shed.CompoundIterator;
import net.java.truecommons.shed.SuppressedExceptionBuilder;

@NotThreadSafe
public class MultiplexingOutputService<E extends MutableEntry>
extends DecoratingOutputService<E> {
    private final IoBufferPool pool;
    private final Map<String, BufferedEntryOutputStream> buffers = new LinkedHashMap<String, BufferedEntryOutputStream>();
    private boolean busy;

    public MultiplexingOutputService(IoBufferPool pool, @WillCloseWhenClosed OutputService<E> output) {
        super(output);
        this.pool = Objects.requireNonNull(pool);
    }

    public int size() {
        return ((OutputService)this.container).size() + this.buffers.size();
    }

    public Iterator<E> iterator() {
        return new CompoundIterator(((OutputService)this.container).iterator(), (Iterator)new BufferedEntriesIterator());
    }

    @CheckForNull
    public E entry(String name) {
        MutableEntry entry = (MutableEntry)((OutputService)this.container).entry(name);
        if (null != entry) {
            return (E)entry;
        }
        BufferedEntryOutputStream out = this.buffers.get(name);
        return null == out ? null : (E)out.getTarget();
    }

    public OutputSocket<E> output(E local) {
        Objects.requireNonNull(local);
        final class Output
        extends DecoratingOutputSocket<E> {
            final /* synthetic */ MutableEntry val$local;

            Output() {
                this.val$local = mutableEntry;
                super(((OutputService)MultiplexingOutputService.this.container).output((Entry)mutableEntry));
            }

            public E target() {
                return this.val$local;
            }

            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                return MultiplexingOutputService.this.isBusy() ? new BufferedEntryOutputStream(this.socket(), peer) : new EntryOutputStream(this.socket().stream(peer));
            }
        }
        return new Output();
    }

    public boolean isBusy() {
        return this.busy;
    }

    @DischargesObligation
    public void close() throws IOException {
        if (this.isBusy()) {
            throw new IOException("This multiplexing output service is still busy with writing a stream!");
        }
        this.storeBuffers();
        assert (this.buffers.isEmpty());
        ((OutputService)this.container).close();
    }

    final void storeBuffers() throws IOException {
        if (!this.isBusy()) {
            Iterator<BufferedEntryOutputStream> i = this.buffers.values().iterator();
            while (i.hasNext()) {
                if (!i.next().storeBuffer()) continue;
                i.remove();
            }
        }
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final InputSocket<?> input;
        final OutputSocket<? extends E> output;
        final IoBuffer buffer;
        boolean closed;

        @CreatesObligation
        BufferedEntryOutputStream(@CheckForNull OutputSocket<? extends E> output, InputSocket<? extends Entry> input) throws IOException {
            this.output = output;
            MutableEntry local = (MutableEntry)this.output.target();
            Entry _peer = null != input ? input.target() : null;
            final IoBuffer buffer = this.buffer = (IoBuffer)MultiplexingOutputService.this.pool.allocate();
            final Entry peer = null != _peer ? _peer : buffer;
            try {
                final class InputProxy
                extends DecoratingInputSocket<Entry> {
                    InputProxy() {
                        super(ioBuffer.input());
                    }

                    public Entry target() {
                        return peer;
                    }
                }
                this.input = new InputProxy();
                this.out = buffer.output().stream(null);
            }
            catch (Throwable ex) {
                try {
                    buffer.release();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
            MultiplexingOutputService.this.buffers.put(local.getName(), this);
        }

        E getTarget() {
            try {
                return (MutableEntry)this.output.target();
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @DischargesObligation
        public void close() throws IOException {
            SuppressedExceptionBuilder builder = new SuppressedExceptionBuilder();
            if (!this.closed) {
                this.closed = true;
                try {
                    this.out.close();
                    MutableEntry local = (MutableEntry)this.output.target();
                    if (this == MultiplexingOutputService.this.buffers.get(local.getName())) {
                        this.updateProperties(local, this.input.target());
                    } else {
                        this.discardBuffer();
                    }
                }
                catch (IOException ex) {
                    builder.warn((Throwable)ex);
                }
            }
            try {
                MultiplexingOutputService.this.storeBuffers();
            }
            catch (IOException ex) {
                builder.warn((Throwable)ex);
            }
            builder.check();
        }

        void updateProperties(E local, Entry peer) {
            for (Entry.Access type : Entry.ALL_ACCESS) {
                if (-1L != local.getTime(type)) continue;
                local.setTime(type, peer.getTime(type));
            }
            if (-1L == local.getSize(Entry.Size.DATA)) {
                local.setSize(Entry.Size.DATA, peer.getSize(Entry.Size.DATA));
            }
        }

        void discardBuffer() throws IOException {
            assert (this.closed);
            this.buffer.release();
        }

        boolean storeBuffer() throws IOException {
            if (!this.closed || MultiplexingOutputService.this.isBusy()) {
                return false;
            }
            IoSockets.copy(this.input, this.output);
            this.buffer.release();
            return true;
        }
    }

    private final class EntryOutputStream
    extends DecoratingOutputStream {
        boolean closed;

        EntryOutputStream(OutputStream out) {
            super(out);
            MultiplexingOutputService.this.busy = true;
        }

        @DischargesObligation
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                MultiplexingOutputService.this.busy = false;
                this.out.close();
            }
            MultiplexingOutputService.this.storeBuffers();
        }
    }

    private class BufferedEntriesIterator
    implements Iterator<E> {
        final Iterator<BufferedEntryOutputStream> i;

        private BufferedEntriesIterator() {
            this.i = MultiplexingOutputService.this.buffers.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public E next() {
            return this.i.next().getTarget();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

